///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/**
 *	This file contains the material-related exported structures.
 *	\file		FLX_AddMaterial.h
 *	\author		Pierre Terdiman
 *	\date		April, 4, 2000
 */
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Include Guard
#ifndef __FLX_ADDMATERIAL_H__
#define __FLX_ADDMATERIAL_H__

	//! The material information class.
	class MaterialDescriptor : public ObjectDescriptor
	{
		public:
		// Constructor / Destructor
										MaterialDescriptor();
		virtual							~MaterialDescriptor();

		// Textures
						sdword			mAmbientMapID;						//!< Ambient texture map (seems not to exist anymore in MAX 3)
						sdword			mDiffuseMapID;						//!< Diffuse texture map
						sdword			mSpecularMapID;						//!< Specular texture map
						sdword			mShininessMapID;					//!< Shininess texture map
						sdword			mShiningStrengthMapID;				//!< Shining Strength texture map
						sdword			mSelfIllumMapID;					//!< Self Illum texture map
						sdword			mOpacityMapID;						//!< Opacity texture map
						sdword			mFilterMapID;						//!< Filter texture map
						sdword			mBumpMapID;							//!< Bump texture map
						sdword			mReflexionMapID;					//!< Reflexion texture map
						sdword			mRefractionMapID;					//!< Refraction texture map
						sdword			mDisplacementMapID;					//!< Displacement texture map
		// Amounts
						float			mAmbientCoeff;						//!< Ambient texture %									[Animatable]
						float			mDiffuseCoeff;						//!< Diffuse tetxure %									[Animatable]
						float			mSpecularCoeff;						//!< Specular texture %									[Animatable]
						float			mShininessCoeff;					//!< Shininess texture %								[Animatable]
						float			mShiningStrengthCoeff;				//!< Shining Strength texture %							[Animatable]
						float			mSelfIllumCoeff;					//!< Self Illum texture %								[Animatable]
						float			mOpacityCoeff;						//!< Opacity texture %									[Animatable]
						float			mFilterCoeff;						//!< Filter texture %									[Animatable]
						float			mBumpCoeff;							//!< Bump texture %										[Animatable]
						float			mReflexionCoeff;					//!< Reflexion texture %								[Animatable]
						float			mRefractionCoeff;					//!< Refraction texture %								[Animatable]
						float			mDisplacementCoeff;					//!< Displacement texture %								[Animatable]
		// Colors
						MAXPoint		mMtlAmbientColor;					//!< Ambient Color										[Animatable]
						MAXPoint		mMtlDiffuseColor;					//!< Diffuse Color										[Animatable]
						MAXPoint		mMtlSpecularColor;					//!< Specular Color										[Animatable]
						MAXPoint		mMtlFilterColor;					//!< Filter Color										[Animatable]
		// Static properties
						long			mShading;							//!< Material Shading
						bool			mSoften;							//!< MaterialSoften
						bool			mFaceMap;							//!< MaterialFaceMap
						bool			mTwoSided;							//!< MaterialTwoSided
						bool			mWire;								//!< MaterialWire
						bool			mWireUnits;							//!< MaterialWireUnits
						bool			mFalloffOut;						//!< MaterialFalloffOut
						long			mTransparencyType;					//!< MaterialTransparencyType
		// Dynamic properties
						float			mShininess;							//!< MaterialShininess									[Animatable]
						float			mShiningStrength;					//!< MaterialShiningStrength							[Animatable]
						float			mSelfIllum;							//!< MaterialSelfIllum									[Animatable]
						float			mOpacity;							//!< MaterialOpacity									[Animatable]
						float			mOpaFalloff;						//!< MaterialOpacityFalloff								[Animatable]
						float			mWireSize;							//!< MaterialWireSize									[Animatable]
						float			mIOR;								//!< MaterialIOR										[Animatable]
		// Dynamic properties
						float			mBounce;							//!< Bounce												[Animatable]
						float			mStaticFriction;					//!< Static Friction									[Animatable]
						float			mSlidingFriction;					//!< Sliding Friction									[Animatable]
		// Diffuse map cropping values
						TextureCrop		mCValues;							//!< Cropping values
						TextureMatrix	mTMtx;								//!< Texture matrix
	};

#endif // __FLX_ADDMATERIAL_H__
